package lib.string;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class JSonUtil {
	public static String listToJSON(List<HashMap<String,String>> list) {
		ArrayList<String> recordList = new ArrayList<String>();
		for(HashMap<String,String> map:list) {
			ArrayList<String> setList = new ArrayList<String>();
			for(String key:map.keySet()) {
				String value = map.get(key);
				value = value.replaceAll("\\'", "&#39;");
				String set = "'" + key + "':'" + value + "'";
				setList.add(set);
			}
			String[] ary = new String[setList.size()];
			setList.toArray(ary);
			recordList.add("{" + join(",", ary) + "}");
		}
		String[] ary = new String[recordList.size()];
		recordList.toArray(ary);
		return "[" + join(",", ary) + "]";
	}
	public static String mapToJSON(HashMap<String,String> map) {
		ArrayList<String> setList = new ArrayList<String>();
		for(String key:map.keySet()) {
			String value = map.get(key);
			value = value.replaceAll("\\'", "&#39;");
			value = value.replaceAll("\\r", "\\\\r");
			value = value.replaceAll("\\n", "\\\\n");
			String set = "'" + key + "':'" + value + "'";
			setList.add(set);
		}
		String[] ary = new String[setList.size()];
		setList.toArray(ary);
		String str = "({" + join(",", ary) + "})";
		return str;
	}

	public static String join(String spacer, String[] ary) {
		if(ary.length == 0) {
			return "";
		}
		StringBuffer sb = new StringBuffer(ary[0]);
		for(int i = 1;i < ary.length;i++) {
			sb.append(spacer).append(ary[i]);
		}
		return sb.toString();
	}
}
